
#Generates the plots in Figures 2, 3, and 4.


a<-read.table("T2Normal.txt")
b<-read.table("FRNormal.txt")
c<-read.table("FRNewNormal.txt")
d<-read.table("Normal_HD.txt")

h=seq(0, 3, length.out=20)




pdf(file="Normal.pdf")

scatter.smooth(h[-1], a[,1][-1], type='n', ylim=c(0, 0.9), col='1', xlab="Local Separation", ylab="Power", main=" Normal Location in d=10")
points(loess.smooth(h[-1], b[,1][-1]), type='l', col='2')
points(loess.smooth(h[-1], c[,1][-1]), type='l', col='3')
points(loess.smooth(h[-1], d[,1][-1]), type='l', col='4')


abline(h=0.05, col=5)
legend("topleft", c("T2", "FR", "CF", "HD"), col=c(1,2,3,4),
lty = c(1,1,1,1), bg = 'gray90',text.width = strwidth("1,000,000"))


dev.off()



########################################################


a<-read.table("T2Scale.txt")
b<-read.table("FRScale.txt")
c<-read.table("FRScale.txt")
d<-read.table("Scale_HD.txt")
e<-read.table("CovTest.txt")
f<-read.table("GLRScale.txt")

h=seq(0, 3, length.out=20)




pdf(file="Scale.pdf")

scatter.smooth(h[-1], a[,1][-1], type='n', ylim=c(0, 0.9), col='1', xlab="Local Separation", ylab="Power", main=" Normal Scale in d=10")
points(loess.smooth(h[-1], b[,1][-1]), type='l', col='2')
points(loess.smooth(h[-1], c[,1][-1]), type='l', col='3')
points(loess.smooth(h[-1], d[,1][-1]), type='l', col='4')
points(loess.smooth(h[-1], e[,1][-1]), type='l', col='5')
points(loess.smooth(h[-1], f[,1][-1]), type='l', col='6')


abline(h=0.05, col=7)
legend("topleft", c("T2", "FR", "CF", "HD", "CovTest", "GLR"), col=c(1,2,3,4, 5, 6),
lty = c(1,1,1,1,1,1), bg = 'gray90',text.width = strwidth("1,000,000"))


dev.off()



########################################################




a<-read.table("T2Lognormal.txt")
b<-read.table("FRLognormal.txt")
c<-read.table("FRNewLognormal.txt")
d<-read.table("Lognormal_HD.txt")
e<-read.table("Lognormal_MD.txt")

h=seq(0, 3, length.out=20)




pdf(file="Lognormal.pdf")



scatter.smooth(h[-1], a[,1][-1], type='n', ylim=c(0, 0.9), col=1, xlab="Local Separation", ylab="Power", main=" Lognormal in d=10")
points(loess.smooth(h[-1], b[,1][-1]), type='l', col=2)
points(loess.smooth(h[-1], c[,1][-1]), type='l', col=3)
points(loess.smooth(h[-1], d[,1][-1]), type='l', col=4)
points(loess.smooth(h[-1], e[,1][-1]), type='l', col=5)

abline(h=0.05, col=6)
legend("topleft", c("T2", "FR", "CF", "HD", "MD"), col=c(1,2,3,4,5),
       lty = c(1,1,1,1,1), bg = 'gray90',text.width = strwidth("1,000,000"))


dev.off()
